#include "stdafx.h"
#include "ConfigWriter.h"

CConfigWriter::CConfigWriter(CConfig *Config, RichTextBox *txtConsole)
{
	this->Config = Config;
	this->txtConsole = txtConsole;
}

bool CConfigWriter::WriteConfigFile(String *sFile)
{
	txtConsole->SelectionColor = Color::Green;
	txtConsole->AppendText(String::Concat(S"Writing ", sFile, S"..."));

	StreamWriter *ConfigFile;

	try
	{
		ConfigFile = new StreamWriter(sFile, false, System::Text::Encoding::ASCII);
	}
	catch(Exception *e)
	{
		txtConsole->SelectionColor = Color::Red;
		txtConsole->AppendText(String::Concat(S"Error writing ", sFile, S": ", e->Message, S"\n"));
		return false;
	}

	try
	{
		ConfigFile->WriteLine("[General]");
		ConfigFile->WriteLine("");

		ConfigFile->WriteLine(String::Concat("General.RecentMAPCount = ", Config->iRecentMAPCount.ToString()));

		ConfigFile->WriteLine("");
		ConfigFile->WriteLine("[Engine]");
		ConfigFile->WriteLine("");

		ConfigFile->WriteLine(String::Concat("Engine.ColorBits = ", Config->bColorBits.ToString()));
		ConfigFile->WriteLine(String::Concat("Engine.DepthBits = ", Config->bDepthBits.ToString()));

		ConfigFile->WriteLine(String::Concat("Engine.BackColor.R = ", Config->cBackColor.R.ToString("0.000")));
		ConfigFile->WriteLine(String::Concat("Engine.BackColor.G = ", Config->cBackColor.G.ToString("0.000")));
		ConfigFile->WriteLine(String::Concat("Engine.BackColor.B = ", Config->cBackColor.B.ToString("0.000")));
		ConfigFile->WriteLine(String::Concat("Engine.BackColor.A = ", Config->cBackColor.A.ToString("0.000")));

		ConfigFile->WriteLine(String::Concat("Engine.ForeColor.R = ", Config->cForeColor.R.ToString("0.000")));
		ConfigFile->WriteLine(String::Concat("Engine.ForeColor.G = ", Config->cForeColor.G.ToString("0.000")));
		ConfigFile->WriteLine(String::Concat("Engine.ForeColor.B = ", Config->cForeColor.B.ToString("0.000")));
		ConfigFile->WriteLine(String::Concat("Engine.ForeColor.A = ", Config->cForeColor.A.ToString("0.000")));

		ConfigFile->WriteLine(String::Concat("Engine.HighlightColor.R = ", Config->cHighlightColor.R.ToString("0.000")));
		ConfigFile->WriteLine(String::Concat("Engine.HighlightColor.G = ", Config->cHighlightColor.G.ToString("0.000")));
		ConfigFile->WriteLine(String::Concat("Engine.HighlightColor.B = ", Config->cHighlightColor.B.ToString("0.000")));
		ConfigFile->WriteLine(String::Concat("Engine.HighlightColor.A = ", Config->cHighlightColor.A.ToString("0.000")));

		ConfigFile->WriteLine(String::Concat("Engine.OutlineColor.R = ", Config->cOutlineColor.R.ToString("0.000")));
		ConfigFile->WriteLine(String::Concat("Engine.OutlineColor.G = ", Config->cOutlineColor.G.ToString("0.000")));
		ConfigFile->WriteLine(String::Concat("Engine.OutlineColor.B = ", Config->cOutlineColor.B.ToString("0.000")));
		ConfigFile->WriteLine(String::Concat("Engine.OutlineColor.A = ", Config->cOutlineColor.A.ToString("0.000")));

		ConfigFile->WriteLine("");
		ConfigFile->WriteLine("[Camera]");
		ConfigFile->WriteLine("");

		ConfigFile->WriteLine(String::Concat("Camera.InvertCamera = ", Config->bInvertCamera.ToString()));
		ConfigFile->WriteLine(String::Concat("Camera.CameraSpeed = ", Config->fCameraSpeed.ToString("0.000")));
		ConfigFile->WriteLine(String::Concat("Camera.CameraBoost = ", Config->fCameraBoost.ToString("0.000")));

		ConfigFile->WriteLine("");
		ConfigFile->WriteLine("[Renderer]");
		ConfigFile->WriteLine("");

		ConfigFile->WriteLine(String::Concat("Renderer.DrawSpecialTextures = ", Config->bDrawSpecialTextures.ToString()));
		ConfigFile->WriteLine(String::Concat("Renderer.DrawSelection = ", Config->bDrawSelection.ToString()));
		ConfigFile->WriteLine(String::Concat("Renderer.DrawPointFile = ", Config->bDrawPointFile.ToString()));
		ConfigFile->WriteLine(String::Concat("Renderer.LightScene = ", Config->bLightScene.ToString()));
		ConfigFile->WriteLine(String::Concat("Renderer.OutlineScene = ", Config->bOutlineScene.ToString()));

		ConfigFile->WriteLine(String::Concat("Renderer.RenderMode = ", __box(Config->eRenderMode)->ToString()));
		ConfigFile->WriteLine(String::Concat("Renderer.TextureFilter = ", __box(Config->eTextureFilter)->ToString()));

		ConfigFile->WriteLine("");
		ConfigFile->WriteLine("[Textures]");
		ConfigFile->WriteLine("");

		ConfigFile->WriteLine(String::Concat("Textures.HalfLifePath = ", Config->sHalfLifePath));

		ConfigFile->WriteLine("");
		ConfigFile->WriteLine("[Recent Files]");
		ConfigFile->WriteLine("");
	}
	catch(Exception *e)
	{
		txtConsole->SelectionColor = Color::Red;
		txtConsole->AppendText(String::Concat(S"Error writing ", sFile, S": ", e->Message, S"\n"));
		ConfigFile->Close();
		return false;
	}

	ConfigFile->Close();

	txtConsole->SelectionColor = Color::Green;
	txtConsole->AppendText("done.\n");

	return true;
}